/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair.sensors;

import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Sensor;
import com.ibm.hwmca.fw.service.statetransition.SensorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PIIsolateStatus
implements Sensor {
    private static final String TRACE_MASKT = "XRVPISST";
    private static final String TRACE_MASKF = "XRVPISSF";
    private static final String TRACE_MASKD = "XRVPISSD";

    public PIIsolateStatus() {
        Trace.trace(TRACE_MASKT, "<> PIIsolateStatus.ctor");
    }

    public String fire(Context context) throws SensorException {
        Trace.trace(TRACE_MASKT, "-> PIIsolateStatus.fire");
        Map userData = context.getUserData();
        List fruList = (List)userData.get("SELECTED_FRUS");
        Iterator it = fruList.iterator();
        boolean isolateFruFound = false;
        while (!isolateFruFound && it.hasNext()) {
            int fruFlagValue;
            ServiceableElement se = (ServiceableElement)it.next();
            int n = fruFlagValue = se.getProperty("FLAGS") == null ? 1 : (Integer)se.getProperty("FLAGS");
            if (fruFlagValue == 1 || fruFlagValue == 0 || fruFlagValue == 15) continue;
            Trace.trace(TRACE_MASKF, "PIIsolateStatus.fire found a 'non-hardware' Fru: " + se.getProperty("LOCATION"));
            isolateFruFound = true;
        }
        if (isolateFruFound) {
            Trace.trace(TRACE_MASKT, "-> PIIsolateStatus.fire return SD.DEFINED_NOT_RUN");
            return SD.DEFINED_NOT_RUN;
        }
        Trace.trace(TRACE_MASKT, "-> PIIsolateStatus.fire return NOT_DEFINED");
        return SD.NOT_DEFINED;
    }
}

